/****************************************************************************************
 *                                                                                      *
 * PROGRAM - Demonstration of the ICG Modes - Used S08GB60                              *
 *                                                                                      *
 * VERSION - Ver 1.0                                                                    *
 *                                                                                      *
 * Author  - Steven McLaughlin, Application Engineer, East Kilbride                                                          *
 *                                                                                      *  
 * DATE    - August 2007                                                              *
 *                                                                                      *
 ****************************************************************************************/
 
 /******************************************************************************		
*                                                                                   	
*       Copyright (C) 2006 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       main.c               											
*														              					
* Description:	     	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/	 
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include<MC9S08GB60.h>
volatile unsigned char NVICGTRIM @0x000FFBE;

   
void main(void) 
{

  /*DISABLE THE COP - PREVENTS MCU RESETTING*/
  SOPT_COPE=0; 
 
  
  ICGTRM=NVICGTRIM; //store ICG trim value from NV ICG trim reg into ICG trim reg
  
/*********************************************************************************
 * Configuration FLL engaged; internal clock reference (FEI MODE)                *
 *                                                                               *
 * f(IRG) = 243 kHz                                                              *
 * f(BUS) = 5.4 MHz                                                             *
 * P = 64 (low freuqency range)                                                  *
 *                                                                               *
 * N/R = (2*f(BUS))/((f(IRG)/7) * P) = 10,2                                      *
 *                                                                               *
 * N = 10                                                                        *
 * R = 2                                                                         *
 *********************************************************************************/

/********************** ICG Control register 1 settings ************************** 

   bit 7	  bit 6     bit 5     bit 4 	   bit 3	   bit 2	  	bit 1	   bit 0
 --------- --------- --------- --------- --------- ---------- --------- ---------
|   0     | RANGE   |   REFS  |        CLKS       | OSCSTEN  |   LOCD  |    0    |
 --------- --------- --------- --------- --------- ---------- --------- ---------
|   0     |    0    |    1    |    0    |    1    |     0    |    0    |    0    |
 --------- --------- --------- --------- --------- ---------- --------- --------
 
 HGO     = 0     configure OSC for low power  
 RANGE   = 0     configure OSC for low frequency range; FLL prescale factor is 64                      
 REFS    = 1     Osc using crystal or resonator requested (don't care term)                
 CLKS    = 0b01  FEI Mode 
 OSCSTEN = 0     disable oscillator
 LOCD    = 0     Loss of clock enabled                        

**********************************************************************************/ 

  ICGC1=0b00101000;
  
/********************** ICG Control register 2 settings **************************

   bit 7	 bit 6     bit 5     bit 4 	   bit 3	 bit 2		bit 1	  bit 0
 --------- --------- --------- --------- --------- ---------- --------- ---------
|  LOLRE  |             MFD             |  LOCRE  |              RFD             |
 --------- --------- --------- --------- --------- ---------- --------- ---------
|   0     |    0    |    1    |    1    |    0    |     0    |    0    |    1    |
 --------- --------- --------- --------- --------- ---------- --------- --------
 
                       
 LOLRE    = 0      Generates an interrupt request on loss of lock
 MFD      = 011    Set MFD to 10 (multiplier)
 LOCRE    = 0      Generates an interrupt request on loss of clock 
 RFD      = 001    Sets the RFD division factor to R=2 

**********************************************************************************/ 

  ICGC2=0b00110001;
  
  
  while(ICGS1_LOCK!=1);//wait until FLL is locked
  

  PTFD_PTFD0 = 0;     /* Set port as o/p*/
  PTFDD = 0x01;    

  for(;;) {
  
         PTFD_PTFD0 ^=1;       /* Toggle PTF0 */
        //__RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
